package game;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;


import javax.swing.ImageIcon;


public class EnemySprite {
	
	private CustomImageDataII[] leftImages;
	private CustomImageDataII[] rightImages;
	
	private CustomImageDataII leftDamageFlash;
	private CustomImageDataII rightDamageFlash;
	
	private int frame;
	
	private int width;
	private int height;
	
	private int xPos;
	private int yPos;
	
	private int xPosLeftLimit;
	private int yPosUpperLimit;
	private int xPosRightLimit;
	private int yPosLowerLimit;
	
	private char facing;
	private char direction;
	private int speed;
	
	private int behavior;
	
	private long lastTimeDamaged;
	
	public static final int LEFT_RIGHT = 0;
	public static final int STATIONARY = 1;
	public static final int UP_DOWN = 2;
	public static final int LIGHTNING = 3;
	public static final int TURRET = 4;
	public static final int UP_DOWN_TURRET = 5;
	
	public static final int LIGHTNING_DISTANCE = 150;
	public static final char LIGHTNING_DIR = 'd';
	public static final int LIGHTNING_WIDTH = 16;
	
	private int hitPoints;
	
	
	public static final long LIGHTNING_OVERALL_DURATION = 2000L;
	public static final long LIGHTNING_DISPLAY_THRESHOLD = 800L;
	public static final long LIGHTNING_CHARGEUP = 1000L;
	
	public static final long LIGHTNING_CHARGEUP_TICKS = LIGHTNING_CHARGEUP * 1000000L / PonyPanel.TICK_LENGTH_NANO;
	public static final long LIGHTNING_DISPLAY_THRESHOLD_TICKS = LIGHTNING_DISPLAY_THRESHOLD * 1000000L / PonyPanel.TICK_LENGTH_NANO;
	public static final long LIGHTNING_OVERALL_DURATION_TICKS = LIGHTNING_OVERALL_DURATION * 1000000L / PonyPanel.TICK_LENGTH_NANO;
	
	private long startedLightning = Long.MIN_VALUE;
	
	private long lightningTicks = 0;
	
	public static final long FLASHING_DURATION = 500L;
	
	
	
	
	public EnemySprite() {
		lastTimeDamaged = Long.MIN_VALUE;
		hitPoints  = 20;
		lightningTicks = LIGHTNING_OVERALL_DURATION_TICKS + 1;
	}
	
	public void populateDummy(int xLoc, int yLoc, PonyPanel ponyPanel) {
		
		width = 0;
		height = 0;
		
		xPos = xLoc;
		yPos = yLoc;
		
		xPosLeftLimit = xPos - 50;
		xPosRightLimit = xPos + 250;
		
		speed = 2;
		
		behavior = LEFT_RIGHT;
		facing = 'l';
		frame = 0;
		
		
		leftImages = new CustomImageDataII[10];
		rightImages = new CustomImageDataII[10];
		
		lightningTicks = LIGHTNING_OVERALL_DURATION_TICKS + 1;
		
//		for(int i = 0; i < 4; i++) {
//			
//		}
		
		for(int i = 0; i < 10; i++) {
//			System.out.println("about to try this:  <<" + "images/enemy/elemental R ten " + (i + 1) + " .GIF" + ">>");
//			temp = new ImageIcon(PlayerSprite.class.getResource("images/enemy/elemental L ten " + (i + 1) + ".GIF"));
//			leftImages[i] = new CustomImageData(temp.getImage(), temp.getIconWidth(), temp.getIconHeight(), Color.WHITE, ponyPanel);
			leftImages[i] = new CustomImageDataII("/images/enemy/elemental L ten " + (i + 1) + ".GIF", Color.WHITE, ponyPanel);
			
			width = Math.max(width, leftImages[i].getDesiredWidth());
			height = Math.max(height, leftImages[i].getDesiredHeight());
			
//			temp = new ImageIcon(PlayerSprite.class.getResource("images/enemy/elemental R ten " + (i + 1) + ".GIF"));
//			rightImages[i] = new CustomImageData(temp.getImage(), temp.getIconWidth(), temp.getIconHeight(), Color.WHITE, ponyPanel);
			rightImages[i] = new CustomImageDataII("/images/enemy/elemental R ten " + (i + 1) + ".GIF", Color.WHITE, ponyPanel);
			width = Math.max(width, rightImages[i].getDesiredWidth());
			height = Math.max(height, rightImages[i].getDesiredHeight());
		}
		
//		temp = new ImageIcon(PlayerSprite.class.getResource("images/enemy/elemental L damageFlash.GIF"));
//		leftDamageFlash = new CustomImageData(temp.getImage(), temp.getIconWidth(), temp.getIconHeight(), Color.WHITE, ponyPanel);
		leftDamageFlash = new CustomImageDataII("/images/enemy/elemental L damageFlash.GIF", Color.WHITE, ponyPanel);
		width = Math.max(width, leftDamageFlash.getDesiredWidth());
		height = Math.max(height, leftDamageFlash.getDesiredHeight());
		
//		temp = new ImageIcon(PlayerSprite.class.getResource("images/enemy/elemental R damageFlash.GIF"));
//		rightDamageFlash = new CustomImageData(temp.getImage(), temp.getIconWidth(), temp.getIconHeight(), Color.WHITE, ponyPanel);
		rightDamageFlash = new CustomImageDataII("/images/enemy/elemental R damageFlash.GIF", Color.WHITE, ponyPanel);
		width = Math.max(width, rightDamageFlash.getDesiredWidth());
		height = Math.max(height, rightDamageFlash.getDesiredHeight());
		
	}
	
	
	public void update(PlayerSprite player, PonyPanel caller) {
		frame++;
		
		if(facing == 'l') {
			if(frame >= leftImages.length) 
				frame = 0;
		} else if(facing == 'r') { 
			if(frame >= rightImages.length) 
				frame = 0;
		}
		
		
		
		switch(behavior) {
		default:
		case LEFT_RIGHT:
			updateLeftRight();
			break;
		case UP_DOWN:
			updateFacingBasedOnPlayerPosition(player);
			updateUpDown();
			break;
		case STATIONARY:
			updateFacingBasedOnPlayerPosition(player);
			break;
		case TURRET:
			updateFacingBasedOnPlayerPosition(player);
			updateFiring(caller);
			break;
		case LIGHTNING:
			updateLeftRight();
			updateFiring(caller);
			//have to do a lightning thing later
			break;
		case UP_DOWN_TURRET:
			updateUpDown();
			updateFacingBasedOnPlayerPosition(player);
			updateFiring(caller);
			break;
		}
	}
	
	
	public void updateFiring(PonyPanel panel) {
		

		if(lightningTicks <= LIGHTNING_OVERALL_DURATION_TICKS) {
			lightningTicks++;
			return;
		}
		
		
		int random = (int) (Math.random() * 50);
		
		if(random == 0) {
			switch(behavior) {
			case TURRET:
			case UP_DOWN_TURRET:
				panel.fireEnemyBullet(xPos, yPos, facing);
				break;
			case LIGHTNING:
				//do something
				
//				if(startedLightning + LIGHTNING_OVERALL_DURATION > System.currentTimeMillis())
//					return;
//				
//				startedLightning = System.currentTimeMillis();
				
				lightningTicks = 0;
				
				break;
			default:
				//do nothing
			}
			
		}
		
		
	}
	
	public void updateFacingBasedOnPlayerPosition(PlayerSprite thePlayer) {
		if(thePlayer.getxPos() < xPos) {
			facing = 'l';
		}
		if(thePlayer.getxPos() > xPos) {
			facing = 'r';
		}
	}
	
	public void updateUpDown() {
		
		if(direction == 'u') {
			
			if(yPos <= yPosUpperLimit) {
				direction = 'd';
			} else {
				yPos -= speed;
			}
		
			
		} else if(direction == 'd') {
			
			if(yPos >= yPosLowerLimit) {
				direction = 'u';
			} else {
				yPos += speed;
			}
			
		} else {
//			System.out.println("ERROR:  direction was " + direction + "!");
		}
	}
	
	
	
	public void updateLeftRight() {
		
		if(direction == 'l') {
			
			facing = 'l';
			
			if(frame >= leftImages.length) {
				frame = 0;
			}
			
			
			if(xPos <= xPosLeftLimit) {
				direction = 'r';
				facing = 'r';
			} else {
				xPos -= speed;
			}
			
			
		} else if(direction == 'r') {
			
			facing = 'r';
			
			if(xPos >= xPosRightLimit) {
				direction = 'l';
				facing = 'l';
			} else {
				xPos += speed;
			}
			
		}
	}
	
	private Color getRandomLightningColor() {
		
		int greenValue = (int) (Math.random() * 127) + 128;
		
		return new Color(255, greenValue, 0);
		
	}
	
	
	public void draw(Graphics g, PlayerSprite player, int panelWidth, int panelHeight) {
		
//		System.out.println("<><>DELME about to draw an enemy facing " + Character.toString(facing) + ", at " + (panelWidth/2 + (xPos - player.getxPos())) + ", " + (panelHeight/2 + (yPos - player.getyPos())));
		
		int xDraw = panelWidth/2 + (xPos - player.getxPos());
		int yDraw = panelHeight/2 + (yPos - player.getyPos());
		
		Color lightningColor = getRandomLightningColor();
		
		if(isLightingIngForDraw()) {
			drawLightning(xDraw, yDraw, lightningColor, g, 'd', 150, LIGHTNING_WIDTH);
		}
		
		
		if(System.currentTimeMillis() < lastTimeDamaged + FLASHING_DURATION && frame % 5 <= 1) {
			if(facing == 'l') {
//				System.out.println("<><>DELME about to show the left damage flassh");
				leftDamageFlash.drawObject(g, xDraw, yDraw);
			} else if(facing == 'r') {
//				System.out.println("<><>DELME about to show the RIGHT damage flassh");
				rightDamageFlash.drawObject(g, xDraw , yDraw);
			}
		} else {
			
			try {
			
				if(facing == 'l') {
					leftImages[frame].drawObject(g, xDraw , yDraw);
				} else if(facing == 'r') {
					rightImages[frame].drawObject(g, xDraw , yDraw);
				}
			} catch(NullPointerException e) {
//				e.printStackTrace();
//				System.err.println("frame: " + frame + ", is leftImages null? " + (leftImages == null ? "yes" : (leftImages[frame] == null ? "image is" : "nope")) );
			}
		}
		
		if(isChargingLightning())
			drawLightningCharge(30, xDraw, yDraw, lightningColor, g, LIGHTNING_WIDTH );
		
	}
	
	private static final int LIGHTNING_POINTS_COUNT = 8;
	
	public class IntPoint {
		public int x;
		public int y;
		
		public IntPoint(int theX, int theY) {
			x = theX;
			y = theY;
		}
	}

	public void drawLightningCharge(int radius, int xDraw, int yDraw, Color color, Graphics g, int beamWidth) {
		
		IntPoint pointArray[] = new IntPoint[8];
		
		pointArray[0] = new IntPoint(xDraw, yDraw - radius);
		pointArray[1] = new IntPoint(xDraw + radius * 3/4, yDraw - radius*3/4);
		pointArray[2] = new IntPoint(xDraw + radius, yDraw);
		pointArray[3] = new IntPoint(xDraw + radius * 3/4, yDraw + radius*3/4);
		pointArray[4] = new IntPoint(xDraw, yDraw + radius);
		pointArray[5] = new IntPoint(xDraw - radius * 3/4, yDraw + radius*3/4);
		pointArray[6] = new IntPoint(xDraw - radius, yDraw);
		pointArray[7] = new IntPoint(xDraw - radius * 3/4, yDraw - radius*3/4);
		

		int xOffSet, yOffSet;
		
		for(int i = 0; i < pointArray.length; i++) {
			xOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
			yOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
			pointArray[i].x += xOffSet;
			pointArray[i].y += yOffSet;
		}
		
		
		Color origColor = g.getColor();
		g.setColor(color);
		
		for(int i = 0; i < pointArray.length - 1; i++) {
			
			g.drawLine(pointArray[i].x, pointArray[i].y, pointArray[i + 1].x, pointArray[i+1].y);
			
		}
		
		g.drawLine(pointArray[0].x, pointArray[0].y, pointArray[pointArray.length - 1].x, pointArray[pointArray.length - 1].y);
		
		g.setColor(origColor);
		
		
	}
	
	public void drawLightning(int xDraw, int yDraw, Color color, Graphics g, char dir, int distance, int beamWidth) {
		
		IntPoint pointArray[] = new IntPoint[LIGHTNING_POINTS_COUNT];
		
		int xOffSet, yOffSet;
		
		for(int i = 0; i < LIGHTNING_POINTS_COUNT - 1; i++) {
			
			if(i == 0) {
				pointArray[i] = new IntPoint(xDraw, yDraw);
			} else {
				xOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
				yOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
				
				switch(dir) {
				case 'u':
					pointArray[i] = new IntPoint(xDraw + xOffSet, yDraw - (i * distance / (LIGHTNING_POINTS_COUNT - 1)) + yOffSet);
					break;
				case 'd':
				default:
					pointArray[i] = new IntPoint(xDraw + xOffSet, yDraw + (i * distance / (LIGHTNING_POINTS_COUNT - 1)) + yOffSet);
					break;
				case 'l':
					pointArray[i] = new IntPoint(xDraw - (i * distance / (LIGHTNING_POINTS_COUNT - 1)) + xOffSet, yDraw + yOffSet);
					break;
				case 'r':
					pointArray[i] = new IntPoint(xDraw + (i * distance / (LIGHTNING_POINTS_COUNT - 1)) + xOffSet, yDraw + yOffSet);
					break;
				}
				
			}
			
		}
		
		switch(dir) {
		case 'u':
			pointArray[LIGHTNING_POINTS_COUNT - 1] = new IntPoint(xDraw, yDraw - distance);
			break;
		case 'd':
		default:
			pointArray[LIGHTNING_POINTS_COUNT - 1] = new IntPoint(xDraw, yDraw + distance);
			break;
		case 'l':
			pointArray[LIGHTNING_POINTS_COUNT - 1] = new IntPoint(xDraw - distance, yDraw);
			break;
		case 'r':
			pointArray[LIGHTNING_POINTS_COUNT - 1] = new IntPoint(xDraw + distance, yDraw);
			break;
		}
		
		Color origColor = g.getColor();
		g.setColor(color);
		
		for (int i = 0; i < LIGHTNING_POINTS_COUNT - 1; i++) {
			g.drawLine(pointArray[i].x, pointArray[i].y, pointArray[i+1].x, pointArray[i+1].y); 
		}
		
		g.setColor(origColor);
		
	}
	
	
	public void primeAllImages(Graphics g, int panelWidth, int panelHeight) {
		
//		for(CustomImageDataII c : leftImages) {
//			c.primeImage(g, panelWidth, panelHeight);
//		}
//		for(CustomImageDataII c : rightImages) {
//			c.primeImage(g, panelWidth, panelHeight);
//		}
//		leftDamageFlash.primeImage(g, panelWidth, panelHeight);
//		rightDamageFlash.primeImage(g, panelWidth, panelHeight);
		
	}
	
	public IntRect getCollisionRect() {
		
		return new IntRect(xPos - width/2, yPos - height/2, width, height );
		
	}
	
	public boolean takeDamageReturnDied(int damage) {
//		System.out.println("<><>DELME ouch");
		lastTimeDamaged = System.currentTimeMillis();
		hitPoints -= damage;
		return hitPoints <= 0;
	}

	public int getxPos() {
		return xPos;
	}

	public int getyPos() {
		return yPos;
	}

	public char getFacing() {
		return facing;
	}
	
	public void popupate(int xLoc, int yLoc, int kind, int minRange, int maxRange, char initDir, EnemyImageManager enemyImageManager, PonyPanel ponyPanel) {
		
		width = 0;
		height = 0;
		
		xPos = xLoc;
		yPos = yLoc;
		
		

//		temp = new ImageIcon(PlayerSprite.class.getResource("images/enemy/elemental L damageFlash.GIF"));
//		leftDamageFlash = new CustomImageData(temp.getImage(), temp.getIconWidth(), temp.getIconHeight(), Color.WHITE, ponyPanel);
		leftDamageFlash = new CustomImageDataII("/images/enemy/elemental L damageFlash.GIF", Color.WHITE, ponyPanel);
		
		width = Math.max(width, leftDamageFlash.getDesiredWidth());
		height = Math.max(height, leftDamageFlash.getDesiredHeight());
		
//		temp = new ImageIcon(PlayerSprite.class.getResource("images/enemy/elemental R damageFlash.GIF"));
//		rightDamageFlash = new CustomImageData(temp.getImage(), temp.getIconWidth(), temp.getIconHeight(), Color.WHITE, ponyPanel);
		rightDamageFlash = new CustomImageDataII("/images/enemy/elemental R damageFlash.GIF", Color.WHITE, ponyPanel);
		
		width = Math.max(width, rightDamageFlash.getDesiredWidth());
		height = Math.max(height, rightDamageFlash.getDesiredHeight());
		
		
		String enemyGraphicDirLeft = "/images/enemy/elemental L ten ";
		String enemyGraphicDirRight = "/images/enemy/elemental R ten ";
		
		behavior = kind;
		
		switch(kind) {
		case LEFT_RIGHT:
		default:
			xPosLeftLimit = minRange;
			xPosRightLimit = maxRange;
			yPosUpperLimit = yLoc;
			yPosLowerLimit = yLoc;
			if(xPos > xPosRightLimit)
				xPos = xPosRightLimit;
			else if(xPos < xPosLeftLimit)
				xPos = xPosLeftLimit;
			if(initDir != 'l' && initDir != 'r') {
				direction = 'l';
				facing = 'l';
			} else {
				direction = initDir;
				facing = initDir;
			}
			

			leftImages = enemyImageManager.getBlackEnemyImagesLeft();
			rightImages = enemyImageManager.getBlackEnemyImagesRight();
			width = enemyImageManager.getBlackEnemyWidth();
			height = enemyImageManager.getBlackEnemyHeight();
			
			
			break;
		case STATIONARY:
			xPosLeftLimit = xPos;
			xPosRightLimit = xPos;
			yPosUpperLimit = yPos;
			yPosLowerLimit = yPos;
			
//			enemyGraphicDirLeft = "images/enemy/red/elemental L red ";
//			enemyGraphicDirRight = "images/enemy/red/elemental R red ";

			leftImages = enemyImageManager.getRedEnemyImagesLeft();
			rightImages = enemyImageManager.getRedEnemyImagesRight();
			width = enemyImageManager.getRedEnemyWidth();
			height = enemyImageManager.getRedEnemyHeight();
			
			
			facing = 'l';
			break;
		case UP_DOWN:
			xPosLeftLimit = xPos;
			xPosRightLimit = xPos;
			yPosUpperLimit = minRange;
			yPosLowerLimit = maxRange;
			if(yPos > yPosLowerLimit)
				yPos = yPosLowerLimit;
			else if(yPos < yPosUpperLimit)
				yPos = yPosUpperLimit;
			if(initDir != 'u' && initDir != 'd') {
				direction = 'u';
			} else {
				direction = initDir;
			}

//			enemyGraphicDirLeft = "images/enemy/green/elemental L green ";
//			enemyGraphicDirRight = "images/enemy/green/elemental R green ";

			leftImages = enemyImageManager.getGreenEnemyImagesLeft();
			rightImages = enemyImageManager.getGreenEnemyImagesRight();
			width = enemyImageManager.getGreenEnemyWidth();
			height = enemyImageManager.getGreenEnemyHeight();
			
			facing = 'l';
			break;
		case LIGHTNING:
			xPosLeftLimit = minRange;
			xPosRightLimit = maxRange;
			yPosUpperLimit = yLoc;
			yPosLowerLimit = yLoc;
			if(xPos > xPosRightLimit)
				xPos = xPosRightLimit;
			else if(xPos < xPosLeftLimit)
				xPos = xPosLeftLimit;
			if(initDir != 'l' && initDir != 'r') {
				direction = 'l';
				facing = 'l';
			} else {
				direction = initDir;
				facing = initDir;
			}

//			enemyGraphicDirLeft = "images/enemy/yellow/elemental L yellow ";
//			enemyGraphicDirRight = "images/enemy/yellow/elemental R yellow ";
			

			leftImages = enemyImageManager.getYellowEnemyImagesLeft();
			rightImages = enemyImageManager.getYellowEnemyImagesRight();
			width = enemyImageManager.getYellowEnemyWidth();
			height = enemyImageManager.getYellowEnemyHeight();
			
			
			break;
		case TURRET:
			xPosLeftLimit = xPos;
			xPosRightLimit = xPos;
			yPosUpperLimit = yPos;
			yPosLowerLimit = yPos;
			
//			enemyGraphicDirLeft = "images/enemy/blue/elemental L blue ";
//			enemyGraphicDirRight = "images/enemy/blue/elemental R blue ";
			
			leftImages = enemyImageManager.getBlueEnemyImagesLeft();
			rightImages = enemyImageManager.getBlueEnemyImagesRight();
			width = enemyImageManager.getBlueEnemyWidth();
			height = enemyImageManager.getBlueEnemyHeight();
			
			facing = 'l';
			break;
		case UP_DOWN_TURRET:
			xPosLeftLimit = xPos;
			xPosRightLimit = xPos;
			yPosUpperLimit = minRange;
			yPosLowerLimit = maxRange;
			if(yPos > yPosLowerLimit)
				yPos = yPosLowerLimit;
			else if(yPos < yPosUpperLimit)
				yPos = yPosUpperLimit;
			if(initDir != 'u' && initDir != 'd') {
				direction = 'u';
			} else {
				direction = initDir;
			}

//			enemyGraphicDirLeft = "images/enemy/violet/elemental L violet ";
//			enemyGraphicDirRight = "images/enemy/violet/elemental R violet ";
			
			leftImages = enemyImageManager.getVioletEnemyImagesLeft();
			rightImages = enemyImageManager.getVioletEnemyImagesRight();
			width = enemyImageManager.getVioletEnemyWidth();
			height = enemyImageManager.getVioletEnemyHeight();
			
			facing = 'l';
			break;
		}
		
		
		speed = 2;
		
		frame = 0;
		
		
//		leftImages = new CustomImageData[10];
//		rightImages = new CustomImageData[10];
		
//		for(int i = 0; i < 4; i++) {
//			
//		}
		
//		for(int i = 0; i < 10; i++) {
////			System.out.println("about to try this:  <<" + "images/enemy/elemental R ten " + (i + 1) + " .GIF" + ">>");
//			temp = new ImageIcon(PlayerSprite.class.getResource(enemyGraphicDirLeft + (i + 1) + ".GIF"));
//			leftImages[i] = new CustomImageData(temp.getImage(), temp.getIconWidth(), temp.getIconHeight(), Color.WHITE, null);
//			width = Math.max(width, leftImages[i].getDesiredWidth());
//			height = Math.max(height, leftImages[i].getDesiredHeight());
//			
//			temp = new ImageIcon(PlayerSprite.class.getResource(enemyGraphicDirRight + (i + 1) + ".GIF"));
//			rightImages[i] = new CustomImageData(temp.getImage(), temp.getIconWidth(), temp.getIconHeight(), Color.WHITE, null);
//			width = Math.max(width, rightImages[i].getDesiredWidth());
//			height = Math.max(height, rightImages[i].getDesiredHeight());
//		}
		
		
		
		
	}
	
	
	public boolean isLightingIngForDraw() {
//		return startedLightning + LIGHTNING_OVERALL_DURATION > System.currentTimeMillis() && startedLightning + LIGHTNING_DISPLAY_THRESHOLD < System.currentTimeMillis();
		
		return lightningTicks <= LIGHTNING_OVERALL_DURATION_TICKS && lightningTicks >= LIGHTNING_DISPLAY_THRESHOLD_TICKS;
	}
	
	public boolean isLightingIngForDamage() {
//		return startedLightning + LIGHTNING_OVERALL_DURATION > System.currentTimeMillis() && startedLightning + LIGHTNING_CHARGEUP < System.currentTimeMillis();
		return lightningTicks <= LIGHTNING_OVERALL_DURATION_TICKS && lightningTicks >= LIGHTNING_CHARGEUP_TICKS;
	}
	
	public boolean isChargingLightning() {
//		return startedLightning <= System.currentTimeMillis() && System.currentTimeMillis() < startedLightning + LIGHTNING_CHARGEUP;
		return lightningTicks <= LIGHTNING_CHARGEUP_TICKS;
	}
	
	public IntRect getLightningRect() {
		
		//this is the down-facing lightning rect---there will be no others...for now...
		int x1 = this.getxPos() - LIGHTNING_WIDTH / 2;
		int y1 = this.getyPos();
		
		return new IntRect(x1, y1, LIGHTNING_WIDTH, LIGHTNING_DISTANCE);
		
	}
	
	public int getHP() {
		return hitPoints;
	}
	
}
